unit ST_function;

interface
uses Windows, SysUtils{, Dialogs};

const
  ErrNotLoadDLL=32768;
type

  TUSMC_Devices = packed record
		NOD: DWORD;
		Serial: Pointer; //array of PChar;
		Version: Pointer; //array of PChar;
	end; {USMC_Devices}

  TUSMC_Parameters =record
    AccelT : Single;       // 'Acceleration time (in ms)
    DecelT : Single;       // 'Deceleration time (in ms)
    PTimeout : Single;     //'Time (in ms) after which current will be reduced to 60% of normal
    BTimeout1 : Single;    //'Time (in ms) after which speed of step motor rotation will be equal to the one specified at
                           // 'BTO1P field (see below). (This parameter is used when controlling step motor using buttons)
    BTimeout2 : Single;   //'
    BTimeout3 : Single;   //  '
    BTimeout4 : Single;   // '
    BTimeoutR : Single;   //  'Time (in ms) after which reset command will be performed
    BTimeoutD : Single;   //  'This field is reserved for future use
    MinP : Single ;       //  'Speed (steps/sec) while performing reset operation. (This parameter is used when controlling
                          //  'step motor using buttons)
    BTO1P : Single;       // 'Speed (steps/sec) after BTIMEOUT 1 time have p:sed. (This parameter is used when controlling
                          //  'step motor using buttons)
    BTO2P : Single;       //  '
    BTO3P : Single ;      //  '
    BTO4P : Single ;      //  '
    MaxLoft : WORD;       //  'Value in full steps that will be used performing backl:h operation
    StartPos : DWORD;     // 'This field is reserved for future use
    RTDelta : WORD;    //  'Revolution distance  number of full steps per one full revolution
    RTMinError : WORD;    // 'Number of full steps missed to raise the error flag
    MaxTemp : Single;      // 'Maximum allowed temperature (Celsius)
    SynOUTP : Byte;       // 'Duration of the output synchronization pulse
    LoftPeriod : Single;  // 'Speed of the last phase of the backlash operation.
    EncMult: Single;      // Encoder step multiplier. Should be <Encoder Steps per Revolution>
                          //  / <SM Steps per Revolution> and should be integer multiplied by 0.25
    Reserved: array [1..16] of Byte;    // <Unused> File padding
  end; {USMC_Parameters}

  TUSMC_StartParameters = record
    SDivisor: byte;    //'Step is divided by this factor (1,2,4,8)
    DefDir:  LongBool;    //  'Direction for backlash operation (relative)
    LoftEn:  LongBool;    //  'Enable automatic backlash operation (works if slow start/stop mode is off)
    SlStart:  LongBool;   //  'If TRUE slow start/stop mode enabled.
    WSyncIN:  LongBool;   //  'If TRUE controller will wait for input synchronization signal to start
    SyncOUTR:  LongBool;  //  'If TRUE output synchronization counter will be reset
    ForceLoft:  LongBool; // 'If TRUE and destination position is equal to the current position backlash operation will be performed.
    Reserved: array [1..4] of Byte;  // <Unused> File padding
  end; {USMC_StartParameters}

  TUSMC_Mode = record
    PMode : LongBool;      // 'Turn off buttons (TRUE - buttons disabled)
    PReg : LongBool;       // 'Current reduction regime (TRUE - regime is on)
    ResetD : LongBool;     // 'Turn power off and make a whole step (TRUE - apply)
    EmReset : LongBool;    // 'Quick power off
    Tr1T : LongBool;       // 'Trailer 1 TRUE state (TRUE : +3/+5?; FALSE : 0?)
    Tr2T : LongBool;       // 'Trailer 2 TRUE state (TRUE : +3/+5?; FALSE : 0?)
    RotTrT : LongBool;     // 'Rotary Transducer TRUE state (TRUE : +3/+5?; FALSE : 0?)
    TrSwap : LongBool;     // 'If TRUE, Trailers are treated to be swapped
    Tr1En : LongBool;      // 'If TRUE Trailer 1 Operation Enabled
    Tr2En : LongBool;      // 'If TRUE Trailer 2 Operation Enabled
    RotTeEn : LongBool;    // 'If TRUE Rotary Transducer Operation Enabled
    RotTrOp : LongBool;    // 'Rotary Transducer Operation Select (stop on error for TRUE)
    Butt1T : LongBool;     // 'Button 1 TRUE state (TRUE : +3/+5?; FALSE : 0?)
    Butt2T : LongBool;     // 'Button 2 TRUE state (TRUE : +3/+5?; FALSE : 0?)
    ResetRT : LongBool;    // 'Reset Rotary Transducer Check Positions (need one full revolution before it can detect error)
    SyncOUTEn : LongBool;  // 'If TRUE output syncronization enabled
    SyncOUTR : LongBool;   // 'If TRUE output synchronization counter will be reset
    SyncINOp : LongBool;   // 'Synchronization input mode:
                        //'True - Step motor will move one time to the destination position
                        //'False - Step motor will move multiple times by steps equal to the value destination position
    SyncCount : DWORD; // 'Number of steps after which synchronization output sygnal occures
    SyncInvert : LongBool; // 'Set to TRUE to invert output synchronization signal
    EncoderEn : LongBool; // Enable Encoder on pins {SYNCIN,ROTTR} - disables Synchronization input and Rotary Transducer
    EncoderInv : LongBool; //  Invert Encoder Counter Direction
    ResBEnc : LongBool; //  Reset <EncoderPos> and <ECurPos> to 0
    ResEnc : LongBool; //  Reset <ECurPos> to <EncoderPos>
    Reserved: array [1..8] of Byte;  // <Unused> File padding
  end; {USMC_Mode}

  TUSMC_State = record
    CurPos: integer;      //  'Current position (in microsteps)
    Temp: single;         //  'Current temperature of the driver
    SDivisor:  byte;   //  'Step is divided by this factor
    Loft:  LongBool;      //  'Indicates backlash status
    FullPower:  LongBool; //  'If TRUE then full power.
    CW_CCW:  LongBool;    //  'Current direction. Relatively!
    Power:  LongBool;     //  'If TRUE then Step Motor is ON.
    FullSpeed:  LongBool; //  'If TRUE then full speed. Valid in "Slow Start" mode only.
    AReset:  LongBool;    //  'TRUE After Device reset, FALSE after "Set Position".
    RUN:  LongBool;       //  'Indicates if step motor is rotating
    SyncIN:  LongBool;    //  'Logical state directly from input synchronization PIN
    SyncOUT:  LongBool;   //  'Logical state directly from output synchronization PIN
    RotTr:  LongBool;     //  'Indicates current rotary transducer press state
    RotTrErr:  LongBool;  //  'Indicates rotary transducer error flag
    EmReset:  LongBool;   //  'Indicates state of emergency disable button (local control)
    Trailer1:  LongBool;  //  'Indicates trailer 1 logical state.
    Trailer2:  LongBool;  //  'Indicates trailer 2 logical state.
    Voltage:  Single;     //  'Input power source voltage (6-39V) -=24 version 0nly=-
    Reserved: array [1..8] of Byte;  // <Unused> File padding
  end; {USMC_State}

	TUSMC_EncoderState = record
    EncoderPos : integer;  // Current position measured by encoder
    ECurPos : integer;  // Current position (in Encoder Steps) - Synchronized with request call
    Reserved: array [1..8] of Byte;  // <Unused> File padding
  end;  {USMC_EncoderState}

  D_USMC_Init = function (out USMC_Devices: TUSMC_Devices) : Longword; cdecl;
  D_USMC_GetState = function (Device: Longword;	    // IN - Device number
								            out Str: TUSMC_State  // OUT - Structure representing divice state
								            ) : Longword ; cdecl;
  D_USMC_SaveParametersToFlash = function (Device: Longword	    // IN - Device number
								            ) : Longword ; cdecl;
  D_USMC_GetMode = function ( Device: Longword;				    // IN - Device number
							              out Str: TUSMC_Mode				  // OUT - Structure representing some of divice parameters
							            	): Longword ; cdecl;
  D_USMC_SetMode= function ( Device: Longword;				    // IN - Device number
							              var Str: TUSMC_Mode					// IN/OUT Structure representing some of divice parameters
							              ): Longword ; cdecl;
  D_USMC_GetParameters = function ( Device: Longword;			// IN - Device number
									          out Str: TUSMC_Parameters	  // OUT - Structure representing some of divice parameters
									          ) : Longword ; cdecl;
  D_USMC_SetParameters = function ( Device: Longword;			// IN - Device number
									          var Str: TUSMC_Parameters	  // IN/OUT Structure representing some of divice parameters
									           ): Longword ; cdecl;
  D_USMC_GetStartParameters = function ( Device: Longword;	    // IN - Device number
                            out Str: TUSMC_StartParameters	// OUT - Structure representing start function parameters
                            ) : Longword ; cdecl;
  D_USMC_Start = function ( Device: Longword;				      // IN - Device number
							              DestPos: integer;				   	// IN - Destination position
                            var Speed: single;					// IN/OUT - Speed of rotation
                            out Str: TUSMC_StartParameters	// IN/OUT - Structure representing start function parameters
							              ) : Longword ; cdecl;
  D_USMC_Stop = function ( Device: Longword					      // IN - Device number
							              ) : Longword ; cdecl;
  D_USMC_SetCurrentPosition = function ( Device: Longword;				      // IN - Device number
							              Position: integer				   	// IN - New current position in 1/8 steps (5 least significant bits are ignored)
                            ) : Longword ; cdecl;
  D_USMC_GetEncoderState =  function ( Device: Longword;			// IN - Device number
									          var Str: TUSMC_EncoderState	  //IN/OUT Structure containing encoder state
									          ) : Longword ; cdecl;
  D_USMC_GetLastErr = procedure (ErrString: PChar; Size: Integer) cdecl;
  D_USMC_Close = function : Longword ; cdecl;

	TStandaClass = class(TObject)
    protected
    	HandleStandaDLL: THandle;
		public
			bDllLoadOK: Boolean;
      USMC_Init: D_USMC_Init;
    	USMC_GetState: D_USMC_GetState;
      USMC_SaveParametersToFlash: D_USMC_SaveParametersToFlash;
    	USMC_GetMode: D_USMC_GetMode;
    	USMC_SetMode: D_USMC_SetMode;
    	USMC_GetParameters: D_USMC_GetParameters;
    	USMC_SetParameters: D_USMC_SetParameters;
    	USMC_GetStartParameters: D_USMC_GetStartParameters;
    	USMC_Start: D_USMC_Start;
    	USMC_Stop: D_USMC_Stop;
      USMC_SetCurrentPosition: D_USMC_SetCurrentPosition;
      USMC_GetEncoderState: D_USMC_GetEncoderState;
    	USMC_GetLastErr: D_USMC_GetLastErr;
      USMC_Close: D_USMC_Close;
			function LoadLibAndFuncs : Integer;
			function UnLoadLibAndFuncs : Integer;
    	constructor Create;
			destructor Destroy; override;
    end;
(******************************************************************************)

implementation

constructor TStandaClass.Create;
var
	iError: Integer;
begin
	inherited Create;
	iError := LoadLibAndFuncs;
	if iError <> 0 then
	begin
		bDllLoadOK := false;
    if iError=ErrNotLoadDLL then 	//ShowMessage('TStandaClass.Create: Error "can`t Load DLL" ')
    else ;//ShowMessage('TStandaClass.Create: Error ''' + IntToStr(iError) + ''' from "LoadLibAndFuncs"');
	end else
	begin
		bDllLoadOK := true;
	end;
end;

destructor TStandaClass.Destroy;
var
	iError: Integer;
begin
	iError := UnLoadLibAndFuncs;
	if iError <> 0 then
	begin
//		ShowMessage('TStandaClass.Destroy: Error from "UnLoadLibAndFuncs"');
	end;
	inherited Destroy;
end;


function TStandaClass.LoadLibAndFuncs : Integer;
begin
	Result := 0;

	try
		HandleStandaDLL := LoadLibrary(pChar('USMCDLL.dll'));

		if HandleStandaDLL <> 0 then
		begin
			@USMC_Init := GetProcAddress(HandleStandaDLL, 'USMC_Init');
			@USMC_GetLastErr := GetProcAddress(HandleStandaDLL, 'USMC_GetLastErr');
			@USMC_GetState := GetProcAddress(HandleStandaDLL, 'USMC_GetState');
			@USMC_GetStartParameters := GetProcAddress(HandleStandaDLL, 'USMC_GetStartParameters');
			@USMC_Start := GetProcAddress(HandleStandaDLL, 'USMC_Start');
			@USMC_Stop := GetProcAddress(HandleStandaDLL, 'USMC_Stop');
			@USMC_GetParameters := GetProcAddress(HandleStandaDLL, 'USMC_GetParameters');
			@USMC_SetParameters := GetProcAddress(HandleStandaDLL, 'USMC_SetParameters');
			@USMC_GetMode := GetProcAddress(HandleStandaDLL, 'USMC_GetMode');
			@USMC_SetMode := GetProcAddress(HandleStandaDLL, 'USMC_SetMode');
      @USMC_SaveParametersToFlash := GetProcAddress(HandleStandaDLL, 'USMC_SaveParametersToFlash');
      @USMC_SetCurrentPosition := GetProcAddress(HandleStandaDLL, 'USMC_SetCurrentPosition');
      @USMC_GetEncoderState := GetProcAddress(HandleStandaDLL, 'USMC_GetEncoderState');
      @USMC_Close := GetProcAddress(HandleStandaDLL, 'USMC_Close');

			if @USMC_Init = nil then Result := Result + 1;
			if @USMC_GetLastErr = nil then	Result := Result + 2;
			if @USMC_GetState = nil then Result := Result + 4;
			if @USMC_GetStartParameters = nil then	Result := Result + 8;
			if @USMC_Start = nil then	Result := Result + 16;
			if @USMC_Stop = nil then	Result := Result + 32;
			if @USMC_GetParameters = nil then	Result := Result + 64;
			if @USMC_SetParameters = nil then	Result := Result + 128;
			if @USMC_GetMode = nil then	Result := Result + 256;
			if @USMC_SetMode = nil then	Result := Result + 512;
      if @USMC_SaveParametersToFlash = nil then	Result := Result + 1024;
      if @USMC_SetCurrentPosition = nil then	Result := Result + 2048;
      if @USMC_GetEncoderState = nil then	Result := Result + 4096;
      if @USMC_Close = nil then	Result := Result + 8192;

		end else
		begin
			Result := ErrNotLoadDLL;
		end;
	except
		on EExternalException do
			Result := Result + 100000;
		else
			Result := Result + 200000;	{ unexpected }
	end;
end; {LoadLibAndFuncs}

function TStandaClass.UnLoadLibAndFuncs : Integer;
var
	bOK : Boolean;
begin
	Result := 0;

	if HandleStandaDLL <> 0 then
	begin
	 	bOK := FreeLibrary(HandleStandaDLL);
 		if bOK = true then
		begin
			HandleStandaDLL := 0;

 			USMC_Init := nil;
			USMC_GetLastErr := nil;
			USMC_GetState := nil;
			USMC_GetStartParameters := nil;
			USMC_Start := nil;
			USMC_Stop := nil;
			USMC_GetParameters := nil;
			USMC_SetParameters := nil;
			USMC_GetMode := nil;
			USMC_SetMode := nil;
      @USMC_SaveParametersToFlash := nil;
      @USMC_SetCurrentPosition := nil;
      @USMC_GetEncoderState := nil;
      @USMC_Close := nil;
		end else
		begin
			// further: exact info by 'GetLastError()'
			Result := 1;
		end; {if bOK = true then}
	end; {if HandleStandaDLL <> 0 then}
end; {UnLoadLibAndFuncs}


end.
